********************************************************************************
********************************************************************************
* Date: November 2025
** Do: Code to set directories and globals to reproduce Chapters 1-8 of World Inequality Report 2026
*** Author: Ricardo Gómez-Carrera
********************************************************************************
********************************************************************************

/*
For information on how to use the widcode and the World Inequality Database, visit:
	*1. https://wid.world/codes-dictionary/
	*2. https://github.com/world-inequality-database/wid-stata-tool
	*3. https://github.com/world-inequality-database/wid-r-tool
	*4. https://wid.world/document/distributional-national-accounts-dina-guidelines-2025-methods-and-concepts-used-in-the-world-inequality-database/
	
	For other data inputs visit:
	*1. https://github.com/world-inequality-database/wid-world/tree/master/data-input
	
*/

*Directories
clear

if c(username)=="update"{
global root "update"
 } 

global code 			"$root\code"
global work_data 		"$root\work-data"
global raw			 	"$root\raw-data"
global outputs 			"$root\outputs"
cd "$work_data"


if "`c(os)'"=="MacOSX" | "`c(os)'"=="UNIX" {
    global Rpath "/usr/local/bin/R"
}
else {  // windows, change version number if necessary
    global Rpath `"C:\Program Files\R\R-4.4.1\bin\x64\Rterm.exe"' 
} 


global corecountries " "AD" "AE" "AF" "AG" "AI" "AL" "AM" "AO" "AR" "AT" "AU" "AW" "AZ" "BA" "BB" "BD" "BE" "BF" "BG" "BH" "BI" "BJ" "BM" "BN" "BO" "BQ" "BR" "BS" "BT" "BW" "BY" "BZ" "CA" "CD" "CF" "CG" "CH" "CI" "CL" "CM" "CN" "CO" "CR" "CU" "CV" "CW" "CY" "CZ" "DE" "DJ" "DK" "DM" "DO" "DZ" "EC" "EE" "EG" "ER" "ES" "ET" "FI" "FJ" "FM" "FR" "GA" "GB" "GD" "GE" "GG" "GH" "GI" "GL" "GM" "GN" "GQ" "GR" "GT" "GW" "GY" "HK" "HN" "HR" "HT" "HU" "ID" "IE" "IL" "IM" "IN" "IQ" "IR" "IS" "IT" "JE" "JM" "JO" "JP"  "KE" "KG" "KH" "KI" "KM" "KN" "KP" "KR" "KS" "KW" "KY" "KZ" "LA" "LB" "LC" "LI"  "LK" "LR" "LS" "LT" "LU" "LV" "LY" "MA" "MC" "MD" "ME" "MG" "MH" "MK" "ML" "MM" "MN" "MO" "MR" "MS" "MT" "MU" "MV" "MW" "MX" "MY" "MZ" "NA" "NC" "NE" "NG" "NI" "NL" "NO" "NP" "NR" "NZ""
global corecountries " $corecountries "OM" "PA" "PE" "PF" "PG" "PH" "PK" "PL" "PR" "PS" "PT" "PW" "PY" "QA" "RO" "RS" "RU" "RW" "SA" "SB" "SC" "SD" "SE" "SG" "SI" "SK" "SL" "SM" "SN" "SO" "SR" "SS" "ST" "SV" "SX" "SY" "SZ" "TC" "TD" "TG" "TH" "TJ" "TL" "TM" "TN" "TO" "TR" "TT" "TV" "TW" "TZ" "UA" "UG" "US" "UY" "UZ" "VC" "VE" "VG" "VN""VU" "WS" "YE" "ZA" "ZM" "ZW""


gl mainterritories " AE	AR	AU	BD	BR	CA	CD	CI CL	CN	CO	DE	DK	DZ	EG	ES	ET	FR	GB	ID	IN	IR	IT	JP	KE	KR	MA	ML	MM	MX	NE	NG	NL	NO	NZ	PH	PK		RU	RW	SA	SD	SE	TH	TR	TW	US	VN	ZA "
gl residualregions "OA OB OC OD OE OH OI OJ QM"
gl maincountries "$mainterritories $residualregions"


global EURO " AD AL AT BA BE BG CH CY CZ DE DK EE ES FI FR GB GG GI GR HR HU IE IM IS IT JE KS LI LT LU LV MC MD ME MK MT NL NO PL PT RO RS SE SI SK SM "
global NAOC " AU BM CA FJ FM GL KI MH NC NR NZ PF PG PW SB TO TV US VU WS "
global LATA " AG AI AR AW BB BO BQ BR BS BZ CL CO CR CU CW DM DO EC GD GT GY HN HT JM KN KY LC MS MX NI PA PE PR PY SR SV SX TC TT UY VC VE VG "
global MENA " AE BH DZ EG IL IQ IR JO KW LB LY MA OM PS QA SA SY TN TR YE "
global SSAF " AO BF BI BJ BW CD CF CG CI CM CV DJ ER ET GA GH GM GN GQ GW KE KM LR LS MG ML MR MU MW MZ NA NE NG RW SC SD SL SN SO SS ST SZ TD TG TZ UG ZA ZM ZW "
global RUCA " AM AZ BY GE KG KZ RU TJ TM UA UZ "
global EASA " CN HK JP KP KR MN MO TW "
global SSEA " AF BD BN BT ID IN KH LA LK MM MV MY NP  PH PK SG TH TL VN "


*Settings
clear
gl use_widcode 	"YES" //YES or NO
gl year_output 	"2024" 

/*
To use the wid2025 global (below) with all the data in the World Inequality Database in your computer (locally):
 
	1.- Go to https://wid.world/data/
	2.- Select 
		-Indicators	   		-> Add all indicators
		-Country & regions 	-> Add all countres 
		-Years		   		-> Add all years
		-Download Full Dataset
	3.- BE CAREFUL with (erase) file "WID_data_Al.csv" (Albania 1kb). 
	4.- Compile all datasets by running "DownloadCompilator.R" in R

*/
// gl wid2024 "update.dta" 